unit Unit1;

//      Draw  Assign
//    TBitmap  TCanvas     .
//   ,    TImage 
//    Assign   -  . 

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls;

type
  TForm1 = class(TForm)
    ButtonRun: TButton;
    LabelImg: TLabel;
    PaintBox1: TPaintBox;
    Image1: TImage;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    LabelTitle: TLabel;
    ButtonExit: TButton;
    procedure ButtonRunClick(Sender: TObject);
    procedure ButtonExitClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

//   BitMap
//   TRUECOLOR 24   
procedure DublicateBitMap24 (RqSource, RqDest : TBitMap);
//  ------------------------------------
//  PByteArray   SysUtils :
//  PByteArray = ^TByteArray;
//  TByteArray = array[0..32767] of Byte;
//  ------------------------------------
var
  Row, Col : Integer;
  P1,  P2  : PByteArray;
begin
  if RqSource.PixelFormat = pf24bit
  then begin
     RqDest.PixelFormat := RqSource.PixelFormat;
     RqDest.Height := RqSource.Height;
     RqDest.Width  := RqSource.Width;
     for Row := 0 to RqSource.Height -1 do
     begin
       //    BitMap 
       //    
       P1 := RqSource.ScanLine[Row];
       P2 := RqDest.ScanLine[Row];
       //   
       // (     pf24bit : B,G,R )
       for Col := 0 to 3 * RqSource.Width - 1
       do P2^[Col] := P1^[Col];
     end;
   end;
end;

procedure TForm1.ButtonRunClick(Sender: TObject);
// This example shows drawing directly to the BitMap
var
  BitMap1, BitMap2 : TBitMap;
begin
  BitMap1 := TBitMap.create;
  BitMap2 := TBitMap.create;
  try
    //   Bitmap
    BitMap1.LoadFromFile('.\Images\Lion.bmp');
    //   TRUECOLOR 24   
    if BitMap1.PixelFormat = pf24bit
    then begin
       // -----------------------------------
       //   BitMap1  BitMap1
       DublicateBitMap24 (BitMap1, BitMap2);
       // -----------------------------------
       //    
       Canvas.Draw(24,104,BitMap2);
       //    
       Canvas.Brush.Style := bsClear;
       Canvas.Font.Color := clWhite;
       Canvas.TextOut(24 + 10, 104 + 4, '   TForm ');
       // -----------------------------------
       //     Image
       Image1.Picture.Bitmap.PixelFormat := BitMap1.PixelFormat;
       Image1.Picture.Bitmap.Assign(BitMap2);
       //    
       Image1.Canvas.Brush.Style := bsClear;
       Image1.Canvas.Font.Color := clWhite;
       Image1.Canvas.TextOut(10, 4, '   TImage');
       // -----------------------------------
       //    PaintBox
       PaintBox1.Canvas.Draw(0,0,BitMap2);
       //    
       PaintBox1.Canvas.Brush.Style := bsClear;
       PaintBox1.Canvas.Font.Color := clWhite;
       PaintBox1.Canvas.TextOut(10, 4, '   TPaintBox');
       // -----------------------------------
       //    BitMap2
       BitMap2.Canvas.Brush.Style := bsClear;
       BitMap2.Canvas.Font.Color := clWhite;
       BitMap2.Canvas.TextOut(10,4, '   TLabel');
       //    Label
       LabelImg.Canvas.Draw(0,0,BitMap2);
        // -----------------------------------
    end;
  finally
    BitMap1.Free;
    BitMap2.Free;
  end;
end;

//   
procedure TForm1.ButtonExitClick(Sender: TObject);
begin
 Close;
end;

end.
